// Define the interface for the settings
declare var chrome: any;

interface AppSettings {
    eventId: number;
    quantity: number;
    searchType: "Regular" | "Resale";
    minPrice: number;
    maxPrice: number;
    interval: number;
    sound: string;
    errorSound: string;
    startSound: string;
}

// Default settings
const DEFAULT_SETTINGS: AppSettings = {
    eventId: 3730,
    quantity: 1,
    searchType: "Resale",
    minPrice: 0,
    maxPrice: 6000,
    interval: 7000,
    sound: "none",
    errorSound: "none",
    startSound: "none"
};

// Function to save configuration
const saveConfiguration = () => {
    const eventId = (document.getElementById('eventId') as HTMLInputElement).value;
    const quantity = (document.getElementById('quantity') as HTMLInputElement).value;
    const searchType = (document.getElementById('searchType') as HTMLSelectElement).value;
    const minPrice = (document.getElementById('minPrice') as HTMLInputElement).value;
    const maxPrice = (document.getElementById('maxPrice') as HTMLInputElement).value;
    const interval = (document.getElementById('interval') as HTMLInputElement).value;
    const sound = (document.getElementById('soundSelect') as HTMLSelectElement).value;
    const errorSound = (document.getElementById('errorSoundSelect') as HTMLSelectElement).value;
    const startSound = (document.getElementById('startSoundSelect') as HTMLSelectElement).value;

    const settings: AppSettings = {
        eventId: Number(eventId),
        quantity: Number(quantity),
        searchType: searchType as "Regular" | "Resale",
        minPrice: Number(minPrice),
        maxPrice: Number(maxPrice),
        interval: Number(interval),
        sound: sound,
        errorSound: errorSound,
        startSound: startSound
    };

    chrome.storage.local.set({ extensionSettings: settings }, () => {
        const status = document.getElementById('status');
        if (status) {
            status.textContent = 'Settings Saved! Reloading...';

            // Reload the current tab to apply changes
            chrome.tabs.query({ active: true, currentWindow: true }, (tabs: any) => {
                if (tabs[0] && tabs[0].id) {
                    chrome.tabs.reload(tabs[0].id);
                }
            });

            setTimeout(() => {
                status.textContent = '';
            }, 2000);
        }
    });
};

// Function to load configuration
const loadConfiguration = () => {
    chrome.storage.local.get(['extensionSettings'], (result: any) => {
        const settings: AppSettings = result.extensionSettings || DEFAULT_SETTINGS;

        (document.getElementById('eventId') as HTMLInputElement).value = String(settings.eventId);
        (document.getElementById('quantity') as HTMLInputElement).value = String(settings.quantity);
        (document.getElementById('searchType') as HTMLSelectElement).value = settings.searchType;
        (document.getElementById('minPrice') as HTMLInputElement).value = String(settings.minPrice);
        (document.getElementById('maxPrice') as HTMLInputElement).value = String(settings.maxPrice);

        const soundSelect = document.getElementById('soundSelect');
        if (soundSelect) {
            (soundSelect as HTMLSelectElement).value = settings.sound || 'none';
        }

        const errorSoundSelect = document.getElementById('errorSoundSelect');
        if (errorSoundSelect) {
            (errorSoundSelect as HTMLSelectElement).value = settings.errorSound || 'none';
        }

        const startSoundSelect = document.getElementById('startSoundSelect');
        if (startSoundSelect) {
            (startSoundSelect as HTMLSelectElement).value = settings.startSound || 'none';
        }

        const intervalInput = document.getElementById('interval') as HTMLInputElement;
        intervalInput.value = String(settings.interval);

        const intervalVal = document.getElementById('intervalVal');
        if (intervalVal) {
            intervalVal.textContent = String(settings.interval);
        }
    });
};

// Event listeners
document.addEventListener('DOMContentLoaded', () => {
    loadConfiguration();

    // Live update for slider
    const intervalInput = document.getElementById('interval');
    const intervalVal = document.getElementById('intervalVal');

    if (intervalInput && intervalVal) {
        intervalInput.addEventListener('input', (e: Event) => {
            const target = e.target as HTMLInputElement;
            intervalVal.innerText = target.value;
            // Add a small scale effect when changing
            intervalVal.style.transform = 'scale(1.2)';
            setTimeout(() => { intervalVal.style.transform = 'scale(1)'; }, 100);
        });
    }
});

document.getElementById('saveBtn')?.addEventListener('click', saveConfiguration);
