
eventId = 3448;
console.log('starte Bot 3.0');

const getHeaders = (contentType = null) => {
    return {
        'accept': 'application/json, text/plain, */*',
        'accept-language': 'de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7',
        'cookie': document.cookie,
        'priority': 'u=1, i',
        'referer': `https://www.eticketing.co.uk/arsenal/EDP/Event/Index/${eventId}?position=1`,
        'sec-ch-ua': '"Chromium";v="128", "Not;A=Brand";v="24", "Google Chrome";v="128"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"macOS"',
        'sec-fetch-dest': 'empty',
        'sec-fetch-mode': 'cors',
        'sec-fetch-site': 'same-origin',
        'user-agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36',
        'x-requested-with': 'XMLHttpRequest',
        'content-type': contentType,
    }
}


const checkStatus = (result) => {
    switch (result.status) {
        case 200:
            return true;
            break;
        case 400:
            //
            return false;
            break;
        case 401:
            // solve captcha
            // url and then let them solve it. after that start over again
            return false;
            break;
        case 403:
            //send a tone
            return false;
            break;
        default:
            return false;
            break;
    }
}


const checkForTxTickets = async (url) => {
    let result = await fetch('https://www.eticketing.co.uk/arsenal/EDP/Seats/AvailableResale?AreSeatsTogether=false&EventId=3435&MarketType=1&MaximumPrice=10000000&MinimumPrice=0&Quantity=1', {
        headers: getHeaders()
    });

    let data = await result.json();
    if (result.status === 200 && data.length > 0) {
        await lockTicket(data[0]);
    }
}

const checkForResults = async (url) => {
    await purgeLocks(false);
    let result = await fetch(`https://www.eticketing.co.uk/arsenal/EDP/Seats/AvailableRegular?AreSeatsTogether=false&EventId=${eventId}&MaximumPrice=10000000&MinimumPrice=0&Quantity=1`, {
        headers: getHeaders()
      });

        console.log('checking for results', result.status);
        let data = await result.json();
        console.log(data);

        if (result.status === 200 && data.length > 0) {
            
            await lockTicket(data[0]);
        }

};


const lockTicket = async (data) => {
    let lockedTicket = await fetch('https://www.eticketing.co.uk/arsenal/EDP/BestAvailable/RegularSeats', {
        method: 'POST',
        headers: getHeaders('application/json'),
        body: JSON.stringify({
          'EventId': eventId,
          'Quantity': 1,
          'AreSeatsTogether': false,
          'AreaId': data.AreaId,
          'PriceBandId': data.PriceBands[0].PriceBandCode,
          'SeatAttributeIds': [],
          'MinimumPrice': 0,
          'MaximumPrice': 10000000
        })
      });

        console.log('locked ticket', lockedTicket.status);

        await putLockedTicket(await lockedTicket.json());
}


const putLockedTicket = async (data) => {
    console.log(data);
    let putLockedTicket = await fetch('https://www.eticketing.co.uk/arsenal/EDP/BestAvailable/RegularSeats', {
        method: 'PUT',
        headers: getHeaders('application/json'),
        body: JSON.stringify({
          'EventId': eventId,
          Seats: [{
            Id: data.LockedSeats[0].Id,
            PriceClassId: 1,
          }]
        })
    })
    console.log('put locked ticket', putLockedTicket.status);
    await purgeLocks();
}

const purgeLocks = async (basket = true) => {
    let purgeLocks = await fetch('https://www.eticketing.co.uk/arsenal/EDP/BestAvailable/PurgeLocks', {
        method: 'DELETE',
        headers: getHeaders(),
        body: JSON.stringify({
          'eventId': eventId
        })
    })

    console.log('purge locks', purgeLocks.status);
    if (basket) await basketSeats();
}

const basketSeats = async () => {
    let basketSeats = await fetch('https://www.eticketing.co.uk/arsenal/EDP/Ism/BasketSeats', {
        method: 'POST',
        headers: getHeaders('application/json'),
        body: JSON.stringify({
          'eventId': eventId
        })
      });

      console.log('basket seats', basketSeats.status);
      console.log('look in your basket');
}


const startBot = async () => {
    while (true) {
        console.log('checking for results');
        checkForTxTickets('https://www.eticketing.co.uk/arsenal/EDP/Seats/AvailableRegular');
        await new Promise(resolve => setTimeout(resolve, 5000));
    }
}
startBot();




// {
//     "EventId": 3448,
//     "Quantity": 1,
//     "AreSeatsTogether": false,
//     "AreaId": 4120,
//     "SeatAttributeIds": [],
//     "MinimumPrice": 0,
//     "MaximumPrice": 10000000
// }