"use strict";
var _a;
// Default settings
const DEFAULT_SETTINGS = {
    eventId: 3730,
    quantity: 1,
    searchType: "Resale",
    minPrice: 0,
    maxPrice: 6000,
    interval: 7000,
    sound: "none",
    errorSound: "none",
    startSound: "none"
};
// Function to save configuration
const saveConfiguration = () => {
    const eventId = document.getElementById('eventId').value;
    const quantity = document.getElementById('quantity').value;
    const searchType = document.getElementById('searchType').value;
    const minPrice = document.getElementById('minPrice').value;
    const maxPrice = document.getElementById('maxPrice').value;
    const interval = document.getElementById('interval').value;
    const sound = document.getElementById('soundSelect').value;
    const errorSound = document.getElementById('errorSoundSelect').value;
    const startSound = document.getElementById('startSoundSelect').value;
    const settings = {
        eventId: Number(eventId),
        quantity: Number(quantity),
        searchType: searchType,
        minPrice: Number(minPrice),
        maxPrice: Number(maxPrice),
        interval: Number(interval),
        sound: sound,
        errorSound: errorSound,
        startSound: startSound
    };
    chrome.storage.local.set({ extensionSettings: settings }, () => {
        const status = document.getElementById('status');
        if (status) {
            status.textContent = 'Settings Saved! Reloading...';
            // Reload the current tab to apply changes
            chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
                if (tabs[0] && tabs[0].id) {
                    chrome.tabs.reload(tabs[0].id);
                }
            });
            setTimeout(() => {
                status.textContent = '';
            }, 2000);
        }
    });
};
// Function to load configuration
const loadConfiguration = () => {
    chrome.storage.local.get(['extensionSettings'], (result) => {
        const settings = result.extensionSettings || DEFAULT_SETTINGS;
        document.getElementById('eventId').value = String(settings.eventId);
        document.getElementById('quantity').value = String(settings.quantity);
        document.getElementById('searchType').value = settings.searchType;
        document.getElementById('minPrice').value = String(settings.minPrice);
        document.getElementById('maxPrice').value = String(settings.maxPrice);
        const soundSelect = document.getElementById('soundSelect');
        if (soundSelect) {
            soundSelect.value = settings.sound || 'none';
        }
        const errorSoundSelect = document.getElementById('errorSoundSelect');
        if (errorSoundSelect) {
            errorSoundSelect.value = settings.errorSound || 'none';
        }
        const startSoundSelect = document.getElementById('startSoundSelect');
        if (startSoundSelect) {
            startSoundSelect.value = settings.startSound || 'none';
        }
        const intervalInput = document.getElementById('interval');
        intervalInput.value = String(settings.interval);
        const intervalVal = document.getElementById('intervalVal');
        if (intervalVal) {
            intervalVal.textContent = String(settings.interval);
        }
    });
};
// Event listeners
document.addEventListener('DOMContentLoaded', () => {
    loadConfiguration();
    // Live update for slider
    const intervalInput = document.getElementById('interval');
    const intervalVal = document.getElementById('intervalVal');
    if (intervalInput && intervalVal) {
        intervalInput.addEventListener('input', (e) => {
            const target = e.target;
            intervalVal.innerText = target.value;
            // Add a small scale effect when changing
            intervalVal.style.transform = 'scale(1.2)';
            setTimeout(() => { intervalVal.style.transform = 'scale(1)'; }, 100);
        });
    }
});
(_a = document.getElementById('saveBtn')) === null || _a === void 0 ? void 0 : _a.addEventListener('click', saveConfiguration);
